from matplotlib import pyplot as plt
import pandas as pd

plt.style.use("fivethirtyeight")

# excellent for visualizing the distribution of data
# where the data falls within certain boundaries
# similar to bar graph, but groups the data into bins
# instead of plotting each individual value

data = pd.read_csv('survey.csv')
ids = data['Responder_id']
ages = data['Age']

#plt.hist(ages, edgecolor='black')

# plot on logarithmic scale to make this look less extreme
plt.hist(ages, edgecolor='black', log=True)

bins = [10,20,30,40,50,60]
#plt.hist(ages, bins=bins, edgecolor='black')

# plot a vertical line where the median age is
median_age = 29
color = '#fc4f30'

# plot axis vertical line
plt.axvline(median_age, color=color, label="Age Median", linewidth=2)


plt.legend()
plt.title("Ages of Respondents")
plt.xlabel("Ages")
plt.ylabel("Total responders")
plt.tight_layout()
plt.show()